/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.oauth.clientapp;

import com.zoho.oauth.client.ZohoOAuthClient;
import com.zoho.oauth.common.ZohoOAuthException;
import com.zoho.oauth.contract.ZohoOAuthTokens;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ZohoOAuthServlet
extends HttpServlet {
    protected static final Logger LOGGER = Logger.getLogger(ZohoOAuthServlet.class.getName());
    static String dispatchTo;

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        block4: {
            try {
                String code = req.getParameter("code");
                if (code != null) {
                    ZohoOAuthTokens tokens = ZohoOAuthClient.getInstance().generateAccessToken(code);
                    if (dispatchTo != null) {
                        req.setAttribute("oauth_tokens", (Object)tokens.toJSON().toString());
                        RequestDispatcher rd = req.getRequestDispatcher(dispatchTo);
                        rd.forward((ServletRequest)req, (ServletResponse)res);
                        return;
                    }
                    break block4;
                }
                throw new ZohoOAuthException("Grant token not found...");
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Exception occurred while processing OAuth callback request - " + ex);
                ex.printStackTrace();
            }
        }
    }

    public void init(ServletConfig config) throws ServletException {
        dispatchTo = config.getInitParameter("dispatchTo");
        super.init(config);
    }
}

