/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.oauth.clientapp;

import com.zoho.oauth.client.ZohoOAuth;
import com.zoho.oauth.client.ZohoPersistenceHandler;
import com.zoho.oauth.common.ZohoOAuthException;
import com.zoho.oauth.common.ZohoOAuthUtil;
import com.zoho.oauth.contract.ZohoOAuthTokens;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZohoOAuthFilePersistence
implements ZohoPersistenceHandler {
    private static final Logger LOGGER = Logger.getLogger(ZohoOAuthFilePersistence.class.getName());

    @Override
    public void saveOAuthData(ZohoOAuthTokens tokens) throws IOException, ZohoOAuthException {
        try {
            File file = new File(ZohoOAuthFilePersistence.getPersistenceHandlerFilePath());
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file, false);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter writer = new PrintWriter(bw);
            writer.println("useridentifier=" + tokens.getUserMailId());
            writer.println("accesstoken=" + tokens.getAccessToken());
            writer.println("refreshtoken=" + tokens.getRefreshToken());
            writer.println("expirytime=" + tokens.getExpiryTime());
            writer.close();
        }
        catch (ZohoOAuthException | IOException exp) {
            LOGGER.log(Level.SEVERE, "Exception while inserting tokens to file." + exp);
            exp.printStackTrace();
            if (exp instanceof ZohoOAuthException) {
                throw exp;
            }
            throw new ZohoOAuthException(exp);
        }
    }

    @Override
    public ZohoOAuthTokens getOAuthTokens(String userMailId) throws Exception {
        ZohoOAuthTokens tokens = new ZohoOAuthTokens();
        try {
            HashMap<String, String> oauthtokens = ZohoOAuthUtil.getFileAsMap(new FileInputStream(new File(ZohoOAuthFilePersistence.getPersistenceHandlerFilePath())));
            if (!oauthtokens.get("useridentifier").equals(userMailId)) {
                throw new ZohoOAuthException("Given User not found in persistence.");
            }
            tokens.setUserMailId(oauthtokens.get("useridentifier"));
            tokens.setAccessToken(oauthtokens.get("accesstoken"));
            tokens.setRefreshToken(oauthtokens.get("refreshtoken"));
            tokens.setExpiryTime(Long.valueOf(oauthtokens.get("expirytime")));
        }
        catch (Exception exp) {
            LOGGER.log(Level.SEVERE, "Exception while fetching tokens from file." + exp);
            tokens = null;
            if (exp instanceof ZohoOAuthException) {
                throw exp;
            }
            throw new ZohoOAuthException(exp);
        }
        return tokens;
    }

    @Override
    public void deleteOAuthTokens(String userMailId) throws Exception {
        try {
            File file = new File(ZohoOAuthFilePersistence.getPersistenceHandlerFilePath());
            HashMap<String, String> oauthtokens = ZohoOAuthUtil.getFileAsMap(new FileInputStream(file));
            if (!oauthtokens.get("useridentifier").equals(userMailId)) {
                throw new ZohoOAuthException("Given User mail doesn't match with user identifier.");
            }
            FileWriter fw = new FileWriter(file, false);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter writer = new PrintWriter(bw);
            writer.println("");
            writer.close();
        }
        catch (Exception exp) {
            LOGGER.log(Level.SEVERE, "Exception while deleting tokens from file." + exp);
            exp.printStackTrace();
            if (exp instanceof ZohoOAuthException) {
                throw exp;
            }
            throw new ZohoOAuthException(exp);
        }
    }

    public static String getPersistenceHandlerFilePath() {
        return ZohoOAuth.getConfigValue("oauth_tokens_file_path");
    }
}

