/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.setup.restclient;

import com.zoho.crm.library.api.handler.MetaDataAPIHandler;
import com.zoho.crm.library.api.handler.OrganizationAPIHandler;
import com.zoho.crm.library.api.handler.UserAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.common.ZCRMConfigUtil;
import com.zoho.crm.library.crud.ZCRMModule;
import com.zoho.crm.library.crud.ZCRMRecord;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.setup.metadata.ZCRMOrganization;
import java.util.HashMap;

public class ZCRMRestClient {
    public static final ThreadLocal<String> CURRENT_USER_EMAIL = new ThreadLocal();
    public static HashMap<String, String> staticHeaders = new HashMap();
    public static final ThreadLocal<HashMap<String, String>> DYNAMIC_HEADERS = new ThreadLocal();

    private ZCRMRestClient() {
    }

    public static ZCRMRestClient getInstance() {
        return new ZCRMRestClient();
    }

    public static void initialize() throws Exception {
        ZCRMConfigUtil.initialize();
    }

    public static void initialize(HashMap<String, String> zcrmConfigurations, HashMap<String, String> oauthConfigurations) throws Exception {
        ZCRMConfigUtil.initialize(zcrmConfigurations, oauthConfigurations);
    }

    public ZCRMOrganization getOrganizationInstance() {
        return ZCRMOrganization.getInstance();
    }

    public APIResponse getOrganizationDetails() throws ZCRMException {
        return OrganizationAPIHandler.getInstance().getOrganizationDetails();
    }

    public ZCRMModule getModuleInstance(String moduleAPIName) {
        return ZCRMModule.getInstance(moduleAPIName);
    }

    public ZCRMRecord getRecordInstance(String moduleAPIName, long entityId) {
        return ZCRMRecord.getInstance(moduleAPIName, entityId);
    }

    public BulkAPIResponse getAllModules() throws ZCRMException {
        return this.getAllModules(null);
    }

    public BulkAPIResponse getAllModules(String modifiedSince) throws ZCRMException {
        return MetaDataAPIHandler.getInstance().getAllModules(modifiedSince);
    }

    public APIResponse getModule(String moduleName) throws ZCRMException {
        return MetaDataAPIHandler.getInstance().getModule(moduleName);
    }

    public APIResponse getCurrentUser() throws ZCRMException {
        return UserAPIHandler.getInstance().getCurrentUser();
    }

    public static void setCurrentUser(String userEmail) {
        CURRENT_USER_EMAIL.set(userEmail);
    }

    public static String getCurrentUserEmail() {
        return CURRENT_USER_EMAIL.get();
    }

    public static void setDynamicHeaders(HashMap<String, String> headers) {
        DYNAMIC_HEADERS.set(headers);
    }

    public static HashMap getDynamicHeaders() {
        return DYNAMIC_HEADERS.get();
    }

    public static void setStaticHeaders(HashMap<String, String> headers) {
        staticHeaders = headers;
    }

    public static HashMap getStaticHeaders() {
        return staticHeaders;
    }
}

