/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.exception;

import org.json.JSONObject;

public class ZCRMException
extends Exception {
    private String code;
    private String errorMsg;
    private Throwable originalException = null;
    private JSONObject errorDetails;

    public ZCRMException(String code, String message, JSONObject errorDetails) {
        super(message);
        this.code = code;
        this.errorMsg = message;
        this.errorDetails = errorDetails;
    }

    public ZCRMException(String code, String message) {
        this(code, message, null);
    }

    public ZCRMException(String message) {
        this(null, message, null);
    }

    public ZCRMException(Throwable ex) {
        this(null, ex);
    }

    public ZCRMException(String code, Throwable ex) {
        super(ex);
        this.originalException = ex;
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public String getErrorMsg() {
        if (this.originalException != null) {
            return String.valueOf(this.originalException);
        }
        return this.errorMsg;
    }

    public JSONObject getErrorDetails() {
        return this.errorDetails;
    }

    @Override
    public String toString() {
        String returnMsg = ZCRMException.class.getName() + ". Caused by : ";
        returnMsg = this.code != null ? returnMsg + this.code + " - " + this.getErrorMsg() : returnMsg + this.getErrorMsg();
        if (this.getErrorDetails() != null && this.getErrorDetails().length() > 0) {
            returnMsg = returnMsg + " - " + this.getErrorDetails();
        }
        return returnMsg;
    }
}

