/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.crud;

import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.common.CommonUtil;
import com.zoho.crm.library.common.ZCRMEntity;
import com.zoho.crm.library.crud.ZCRMModule;
import com.zoho.crm.library.exception.ZCRMException;
import java.util.ArrayList;
import java.util.List;

public class ZCRMCustomView
extends ZCRMEntity {
    private String moduleAPIName;
    private String displayName;
    private String name;
    private String systemName;
    private long id;
    private String sortBy;
    private CommonUtil.SortOrder sortOrder;
    private String category;
    private List<String> fields = new ArrayList<String>();
    private Integer favorite;
    private Boolean isDefault;

    private ZCRMCustomView(String moduleAPIName, Long customViewId) {
        this.moduleAPIName = moduleAPIName;
        this.id = customViewId;
    }

    public static ZCRMCustomView getInstance(String moduleAPIName, Long customViewId) {
        return new ZCRMCustomView(moduleAPIName, customViewId);
    }

    public String getModuleAPIName() {
        return this.moduleAPIName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public CommonUtil.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(CommonUtil.SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Integer getFavorite() {
        return this.favorite;
    }

    public void setFavorite(Integer favorite) {
        this.favorite = favorite;
    }

    public BulkAPIResponse getRecords() throws ZCRMException {
        return this.getRecords(false);
    }

    public BulkAPIResponse getRecords(Boolean includePrivateFields) throws ZCRMException {
        return this.getRecords(1, 200, null, includePrivateFields);
    }

    public BulkAPIResponse getRecords(List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        return this.getRecords(1, 200, fields, includePrivateFields);
    }

    public BulkAPIResponse getRecords(int page, int per_page, List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        return this.getRecords(null, null, page, per_page, null, fields, includePrivateFields);
    }

    public BulkAPIResponse getRecords(String sortByField, CommonUtil.SortOrder sortOrder, List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        return this.getRecords(sortByField, sortOrder, 1, 200, null, fields, includePrivateFields);
    }

    public BulkAPIResponse getRecords(String sortByField, CommonUtil.SortOrder sortOrder, int startIndex, int endIndex, String modifiedSince, List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        return ZCRMModule.getInstance(this.moduleAPIName).getRecords(this.id, sortByField, sortOrder, startIndex, endIndex, modifiedSince, fields, includePrivateFields);
    }
}

