/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.common;

import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonUtil {
    public static HashMap<String, String> convertJSONObjectToHashMap(JSONObject json) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            try {
                returnMap.put(key, json.getString(key));
            }
            catch (JSONException je) {
                ZCRMLogger.logError(je);
            }
        }
        return returnMap;
    }

    public static HashMap<String, String> getFileAsMap(InputStream ins) throws ZCRMException {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(ins));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] props = line.split("=");
                if (props[0].startsWith("#")) continue;
                String val = null;
                if (props.length == 2) {
                    val = props[1];
                }
                map.put(props[0], val);
            }
            ins.close();
            return map;
        }
        catch (Exception e) {
            ZCRMLogger.logError(e);
            throw new ZCRMException(e);
        }
    }

    public static void saveStreamAsFile(InputStream inStream, String filePath, String fileName) throws IOException {
        Path path = Paths.get(filePath, fileName);
        Files.copy(inStream, path, new CopyOption[0]);
        inStream.close();
    }

    public static Timestamp isoStringToGMTTimestamp(String isoTime) throws Exception {
        if (isoTime == null) {
            return null;
        }
        Timestamp ts = null;
        Boolean add = true;
        String splitChar = "\\-";
        isoTime = isoTime.replaceAll("z", "+00:00");
        if ((isoTime = isoTime.replaceAll("Z", "+00:00")).contains("+")) {
            add = false;
            splitChar = "\\+";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date da = sdf.parse(isoTime);
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(da.getTime());
        String[] dt = isoTime.split("T");
        String tz = dt[1].split(splitChar)[1];
        int hoursOffset = Integer.parseInt(tz.split(":")[0]);
        int minsOffset = Integer.parseInt(tz.split(":")[1]);
        cal.add(10, add != false ? hoursOffset : -hoursOffset);
        cal.add(12, add != false ? minsOffset : -minsOffset);
        ts = new Timestamp(cal.getTimeInMillis());
        return ts;
    }

    public static String millisecToISO(Long millis, TimeZone toTz) throws ZCRMException {
        if (millis == null) {
            return null;
        }
        toTz = toTz == null ? TimeZone.getTimeZone("GMT") : toTz;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        format.setTimeZone(toTz);
        return format.format(millis).replaceAll("z", "+00:00").replaceAll("Z", "+00:00");
    }

    public static void validateFile(String filePath) throws ZCRMException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new ZCRMException("No such file or directory.");
        }
        if (file.length() / 0x100000L > 20L) {
            throw new ZCRMException("File size is more than allowed size.");
        }
    }

    public static String collectionToCommaDelimitedString(String list, String separator) {
        list = list.replaceAll(" ", "");
        list = list.replace("]", "");
        list = list.replace("[", "");
        return list;
    }

    public static JSONArray getTriggersAsJSONArray(List<Trigger> triggers) {
        JSONArray array = new JSONArray();
        if (triggers.contains((Object)Trigger.workflow)) {
            array.put((Object)Trigger.workflow.toString());
        }
        if (triggers.contains((Object)Trigger.blueprint)) {
            array.put((Object)Trigger.blueprint.toString());
        }
        if (triggers.contains((Object)Trigger.approval)) {
            array.put((Object)Trigger.approval.toString());
        }
        return array;
    }

    public static enum Trigger {
        workflow,
        approval,
        blueprint;

    }

    public static enum CurrencyRoundingOption {
        round_off,
        round_down,
        round_up,
        normal;

    }

    public static enum ConsentProcessThrough {
        Email,
        Phone,
        Survey,
        Social;

    }

    public static enum RestrictedType {
        Low,
        High;

    }

    public static enum PhotoSize {
        stamp,
        thumb,
        original,
        favicon,
        medium;

    }

    public static enum SortOrder {
        asc,
        desc;

    }
}

