/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.response;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.response.CommonAPIResponse;
import com.zoho.crm.library.exception.ZCRMException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class FileAPIResponse
extends CommonAPIResponse {
    public FileAPIResponse(HttpResponse response) throws ZCRMException, JSONException, IOException {
        super(response, null);
    }

    public String getFileName() {
        String fileMeta = this.response.getFirstHeader("Content-Disposition").getValue();
        String fileName = fileMeta.split("=")[1];
        if (fileName.contains("''")) {
            fileName = fileName.split("''")[1];
        }
        return fileName;
    }

    @Override
    protected void setResponseJSON() throws IOException, JSONException {
        if (this.httpStatusCode == APIConstants.ResponseCode.OK || this.httpStatusCode == APIConstants.ResponseCode.NO_CONTENT) {
            this.responseJSON = new JSONObject();
            if (this.httpStatusCode == APIConstants.ResponseCode.OK) {
                this.status = "success";
            }
        } else {
            this.responseJSON = new JSONObject(EntityUtils.toString((HttpEntity)this.response.getEntity()));
        }
    }

    @Override
    protected void handleForFaultyResponses() throws JSONException, ZCRMException {
        if (this.httpStatusCode != APIConstants.ResponseCode.NO_CONTENT) {
            throw new ZCRMException(this.responseJSON.getString("code"), this.responseJSON.getString("message"));
        }
    }

    public InputStream getFileAsStream() throws IOException {
        HttpEntity entity = this.response.getEntity();
        if (entity != null) {
            return entity.getContent();
        }
        return null;
    }
}

